/*
 * Decompiled with CFR 0.152.
 */
package ptqi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp2.DayTimeRounder;
import cz.insophy.inplan.mrp2.DefaultMaterialChangesCollector;
import cz.insophy.inplan.mrp2.DefaultSupplyFactory;
import cz.insophy.inplan.mrp2.GorSupply;
import cz.insophy.inplan.mrp2.MaterialAggHorizonTimeRounder;
import cz.insophy.inplan.mrp2.MaterialIncrementalMrpNamingStrategy;
import cz.insophy.inplan.mrp2.Mrp;
import cz.insophy.inplan.mrp2.MrpNamingStrategy;
import cz.insophy.inplan.mrp2.PrDdSortKey;
import cz.insophy.inplan.mrp2.PrDdSortKeyExtractor;
import cz.insophy.inplan.mrp2.PrioPropertyTransferer;
import cz.insophy.inplan.mrp2.PullOrdering;
import cz.insophy.inplan.mrp2.SortedPairingAlgorithm;
import cz.insophy.inplan.mrp2.SrAdder;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.mrp2.SupplyCreationException;
import cz.insophy.inplan.planning.PlanningAdapter;
import cz.insophy.inplan.planning.PlanningAlgorithmController;
import cz.insophy.inplan.planning.PlanningProgressEvent;
import cz.insophy.inplan.planning.PlanningRunner;
import cz.insophy.inplan.planning.mokos.ActiongramBoundUpdater;
import cz.insophy.inplan.planning.mokos.AlwaysRebuildStrategy;
import cz.insophy.inplan.planning.mokos.GorLongPropertyScorer;
import cz.insophy.inplan.planning.mokos.IdScorer;
import cz.insophy.inplan.planning.mokos.LexicographicSelector;
import cz.insophy.inplan.planning.mokos.MaterialBoundUpdater;
import cz.insophy.inplan.planning.mokos.MinBoundUpdater;
import cz.insophy.inplan.planning.mokos.MokosScoreDefinition;
import cz.insophy.inplan.planning.mokos.OperationDependencyFilter;
import cz.insophy.inplan.planning.mokos.ParallelPositioningProcessor;
import cz.insophy.inplan.planning.mokos.PlanningEndScorer;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.RebuildPositioningStart;
import cz.insophy.inplan.planning.mokos.SameWorkplaceBoundUpdater;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.WeakFixationScorer;
import cz.insophy.inplan.planning.mokos.WorkplaceBoundUpdater;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.StarvingGors;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.errlog.ErrorLog;
import cz.insophy.inplan.util.problems.Problem;
import cz.insophy.inplan.validation.PlanNotValidException;
import cz.insophy.inplan.validation.ValidationResult;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptqi.CombinedTimeRounder;
import ptqi.PlantuneDllMrp;
import ptqi.RuntimeInterruptedException;

public class Planner {
    private static final Logger log = LoggerFactory.getLogger(Planner.class);
    private static final boolean USE_NEW_MRP = true;
    private final Superplan superplan;
    private final ErrorLog errorLog;
    private final List<PlannerProgressListener> listeners;

    public Planner(Superplan superplan, ErrorLog errorLog) {
        this.superplan = superplan;
        this.errorLog = errorLog;
        this.listeners = Lists.newArrayList();
    }

    private void removeCompletedGors() {
        List<GeneralizedOrderRequest> toRemove = this.superplan.getGors().stream().filter(gor -> gor.getAmount() < 1.0E-7).toList();
        for (GeneralizedOrderRequest gor2 : toRemove) {
            this.superplan.removeGor(gor2);
            this.errorLog.add(0, "completed_gor.removed", "mo", gor2.getId());
        }
    }

    private void addMissingTools() {
        List<Problem> toolProblems = StarvingGors.fixTools(this.superplan);
        for (Problem p : toolProblems) {
            if ("34000".equals(p.getErrorCode())) {
                this.errorLog.add(1, "missing_tool.add", "material", p.getReference());
                continue;
            }
            this.errorLog.add(1, "missing_tool.other");
        }
    }

    private void shiftCooperations() {
        long fixationDate = this.superplan.getFixationDate();
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            for (GeneralizedActionRequest gar : gor.getGars()) {
                Action action = gar.getAction();
                if (!action.getCapabilityReq().equals("_cooperation")) continue;
                gar.setReleaseDate(fixationDate + action.getMinTimeToPrepare());
            }
        }
    }

    private boolean runMokos() {
        final AtomicBoolean mokosResult = new AtomicBoolean(false);
        SimpleMokosRunner runner = new SimpleMokosRunner();
        try {
            runner.setSuperplan(this.superplan);
        }
        catch (PlanNotValidException planNotValidException) {
            // empty catch block
        }
        PlanningAlgorithmController pac = runner.getPlanningAlgorithmController();
        pac.addPlanningListener(new PlanningAdapter(){

            @Override
            public void onProgress(PlanningProgressEvent e) {
                if (0 != e.getUnitCount()) {
                    Planner.this.notifyProgressChanged((double)e.getUnit() / (double)e.getUnitCount());
                } else {
                    Planner.this.notifyProgressChanged(1.0);
                }
                if (e.getUnit() == e.getUnitCount()) {
                    mokosResult.set(true);
                }
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
            }
        });
        runner.run();
        return mokosResult.get();
    }

    private void logUnplannedGors() {
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            if (!gor.isUserSelected() || !(gor.getAmount() > 1.0E-7)) continue;
            this.errorLog.add(1, "plan.cannot_plan", "gor", gor.getId());
        }
    }

    private void logIncompleteCrs() {
        StoreDependencyGraph sdg = this.superplan.getSDGraph();
        for (CustomerRequest cr : this.superplan.getCustomerRequests()) {
            SdgCrNode n = sdg.getNode(cr);
            if (n.isComplete()) continue;
            double miss = cr.getQty() - n.getTotalIncomingQty(cr.getMaterial());
            this.errorLog.add(1, "plan.incomplete_cr", "cr_name", cr.getId(), "missing", miss, "total", cr.getQty());
        }
    }

    private void logBrokenMaterials() {
        StoreSchedule ss = this.superplan.getPlan().getStoreSchedule(StoreType.POSSIBLE_ESTIMATE_VIEW);
        for (Material m3 : this.superplan.getShopConf().getMaterials()) {
            double q;
            if (GeneralizedOrderRequest.isDateValid(m3.getMaterialHorizon()) || !((q = ss.getInfTimeQty(m3)) < -1.0E-7)) continue;
            this.errorLog.add(2, "plan.unorderable_material", "material", m3.getName(), "missing", -q);
        }
    }

    private void addSrs() {
        CombinedTimeRounder timeRounder = new CombinedTimeRounder(Arrays.asList(new DayTimeRounder(), new MaterialAggHorizonTimeRounder()));
        SrAdder srAdder = new SrAdder(this.superplan).setAggregate(true).setTimeRounder(timeRounder).setUseSafetyStock(true).setFillSafetyStockAtHorizon(true).setUseBatches(true).setRespectMaterialHorizon(true).setAddSrsToPlan(true);
        srAdder.run();
    }

    private void runMrp() {
        Mrp.fixGorDds(this.superplan);
        int cnt = new Mrp<PrioPropertyTransferer.Properties>(this.superplan, new DefaultMaterialChangesCollector(), new SortedPairingAlgorithm<PrDdSortKey>(new PrDdSortKeyExtractor()), new PrioPropertyTransferer(this.superplan), new SupplyFactory(this.superplan, new MaterialIncrementalMrpNamingStrategy(this.superplan))).run(Mrp.ModifySuperplan.MODIFY).size();
        log.info("MRP done. {} GORs added.", (Object)cnt);
    }

    private void runNewMrp() {
        Mrp.fixGorDds(this.superplan);
        new PlantuneDllMrp(this.superplan, this.errorLog).run();
    }

    private void setRds() {
        PropertyDefinition preprodHorizonPd = this.superplan.getShopConf().getPropertyDefinition(Product.class, "preprodHorizon");
        Preconditions.checkNotNull(preprodHorizonPd, "%s property not defined", (Object)"preprodHorizon");
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            Product prod;
            Long preprodHorizon;
            if (gor.getState() != GeneralizedOrderRequest.State.PROPOSED || gor.getPriority() >= 10 || (preprodHorizon = (Long)(prod = gor.getProduct()).getProperty(preprodHorizonPd)) == null || preprodHorizon <= 0L || gor.getGars().isEmpty()) continue;
            long minLps = gor.getGars().get(0).getLatestPossibleStart();
            long rd = Math.max(gor.getReleaseDate(), minLps - preprodHorizon);
            if (rd <= this.superplan.getFixationDate()) continue;
            gor.setReleaseDate(rd);
        }
    }

    public boolean run() throws InterruptedException {
        try {
            this.checkInterrupted();
            this.removeCompletedGors();
            log.info("Removed completed GORs.");
            this.checkInterrupted();
            this.runNewMrp();
            this.checkInterrupted();
            this.setRds();
            this.checkInterrupted();
            PullOrdering.calculate(this.superplan, PullOrdering.Method.LPS);
            log.info("Pull ordering calculated.");
            this.checkInterrupted();
            this.addMissingTools();
            log.info("Added missing tools.");
            this.checkInterrupted();
            this.shiftCooperations();
            log.info("Shifted cooperation GARs.");
            this.checkInterrupted();
            boolean res = this.runMokos();
            log.info("Planning finished.");
            this.checkInterrupted();
            this.addSrs();
            log.info("Added supply requests.");
            this.logUnplannedGors();
            this.logBrokenMaterials();
            this.logIncompleteCrs();
            log.info("Planning problems logged.");
            return res;
        }
        catch (RuntimeInterruptedException e) {
            throw new InterruptedException();
        }
    }

    public void addProgressListener(PlannerProgressListener l) {
        this.listeners.add(l);
    }

    private void notifyProgressChanged(double progress) {
        for (PlannerProgressListener listener : this.listeners) {
            listener.onProgressChanged(progress);
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static class SimpleMokosRunner
    extends PlanningRunner<Scheduler> {
        private SimpleMokosRunner() {
        }

        @Override
        protected ValidationResult validate(Superplan superplan) {
            return new ValidationResult();
        }

        @Override
        @Nonnull
        protected Scheduler createPlanningAlgorithm() {
            GorLongPropertyScorer pullScorer = new GorLongPropertyScorer();
            pullScorer.setScoreProperty("pullOrdering");
            pullScorer.setDefaultVal(100000L);
            MaterialBoundUpdater materialBoundUpdater = new MaterialBoundUpdater();
            materialBoundUpdater.setMatHorizonTreatment(StoreSchedule.MatHorizonTreatment.MATERIAL_SPECIFIC);
            LexicographicSelector lexicographicSelector = new LexicographicSelector();
            lexicographicSelector.setScoreDefs(new MokosScoreDefinition("weak_fix_score", MokosScoreDefinition.Ordering.SMALL_FIRST), new MokosScoreDefinition("pullOrdering", MokosScoreDefinition.Ordering.SMALL_FIRST), new MokosScoreDefinition("end_score", MokosScoreDefinition.Ordering.SMALL_FIRST), new MokosScoreDefinition("id_score", MokosScoreDefinition.Ordering.LARGE_FIRST));
            ParallelPositioningProcessor positioningProcessor = new ParallelPositioningProcessor();
            positioningProcessor.setRebuildPositioningStart(RebuildPositioningStart.AT_OPERATION_BOUND);
            positioningProcessor.setRebuildPlanningStrategy(new AlwaysRebuildStrategy());
            ImmutableList<Processor> processors = ImmutableList.of(pullScorer, new OperationDependencyFilter(), new ActiongramBoundUpdater(), new WorkplaceBoundUpdater(), new SameWorkplaceBoundUpdater(), materialBoundUpdater, new MinBoundUpdater(), positioningProcessor, new IdScorer(), new PlanningEndScorer(), new WeakFixationScorer(), lexicographicSelector, new Processor[0]);
            for (int i = 1; i < processors.size(); ++i) {
                ((Processor)processors.get(i - 1)).setSuccessors(ImmutableList.of((Processor)processors.get(i)));
            }
            Scheduler scheduler = new Scheduler();
            scheduler.setProcessors(processors);
            scheduler.setSuperplan(this.superplan);
            scheduler.afterPropertiesSet();
            return scheduler;
        }

        @Override
        protected void doRun() {
            Scheduler scheduler = (Scheduler)this.getPlanningAlgorithm();
            scheduler.schedule();
            this.superplan.invalidateSDGraph();
        }
    }

    private class SupplyFactory
    extends DefaultSupplyFactory {
        SupplyFactory(@Nonnull Superplan superplan, MrpNamingStrategy namingStrategy) {
            super(superplan, namingStrategy);
        }

        @Override
        @Nonnull
        public Supply createGorSupply(@Nonnull Product product, double qty) throws SupplyCreationException {
            GorSupply gorSupply = (GorSupply)super.createGorSupply(product, qty);
            String agName = gorSupply.getGor().getSelectedActiongram().getName();
            if (!agName.startsWith("*")) {
                Planner.this.errorLog.add(2, "mrp.no_valid_alternative", "product", product.getName());
                throw new SupplyCreationException("No valid alternative for product " + product.getName());
            }
            return gorSupply;
        }
    }

    public static interface PlannerProgressListener
    extends EventListener {
        public void onProgressChanged(double var1);
    }
}

